USE openPDC
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('50Hertz', '50Hertz', '50Hertz Transmission', 2)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('AEP', 'AEP', 'American Electric Power', 3)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('AGP', 'AGP', 'Allegheny Power', 4)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Amprion', 'Amprion', 'Amprion', 5)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('AMR', 'AMR', 'Ameren', 6)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('APG', 'APG', 'Austrian Power Grid AG', 1)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('AST', 'AST', 'Augstsgrieguma tīkls', 7)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ATC', 'ATC', 'American Transmission Company', 8)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('BCH', 'BCH', 'British Columbia Hydro', 9)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('BE', 'BE', 'NSTAR Electric', 10)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('BH', 'BH', 'Bangor Hydro-Electric Company', 11)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('BPA', 'BPA', 'Bonneville Power Administration', 12)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ČEPS', 'ČEPS', 'ČEPS', 13)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('CGES', 'CGES', 'Crnogorski elektroprenosni sistem AD', 14)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('CONED', 'CED', 'ConEdison', 15)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Creos', 'Creos', 'Creos Luxembourg', 16)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('CX', 'CX', 'Northeast Utilities Services Company', 17)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Cyprus TSO', 'Cyprus TSO', 'Cyprus Transmission System Operator', 18)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('DDL', 'DDL', 'Desired Device Locations', 19)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('DOM', 'DOM', 'Dominion', 20)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('DUKE', 'DUK', 'Duke Power', 21)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('EirGrid', 'EirGrid', 'EirGrid', 22)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Elering', 'Elering', 'Elering', 23)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ELES', 'ELES', 'Elektro-Slovenija', 24)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Elia', 'Elia', 'Elia Transmission Belgium', 25)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('EMS', 'EMS', 'Elektromreža Srbije', 26)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Energinet', 'Energinet', 'Energinet', 27)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ENT', 'ENT', 'Entergy Services Inc', 28)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ESO', 'ESO', 'Electroenergien Sistemen Operator', 29)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('EXE', 'EXE', 'Exelon Energy', 30)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('FEAS', 'FEAS', 'French Hosting Entity of "ENTSO-E Awareness System"', 31)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('FEN', 'FEN', 'First Energy', 32)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Fingrid', 'Fingrid', 'Fingrid', 33)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('FPL', 'FPL', 'Florida Power & Light Company', 34)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('GEAS', 'GEAS', 'German Hosting Entity of "ENTSO-E Awareness System"', 35)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('HEC', 'HEC', 'Hawaiian Electric Company', 36)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('HOPS', 'HOPS', 'Croatian Transmission System Operator', 37)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('HQC', 'HQC', 'Hydro Quebec', 38)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('IPTO', 'IPTO', 'Independent Power Transmission Operator', 39)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ITC', 'ITC', 'International Transmission Company', 40)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Landsnet', 'Landsnet', 'Landsnet', 41)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('LAWP', 'LWP', 'Los Angeles Dept of Water and Power', 42)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('LIPA', 'LPA', 'Long Island Power Authority', 43)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Litgrid', 'Litgrid', 'Litgrid', 44)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MAM', 'MAM', 'MidAmerican Power', 45)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MAVIR', 'MAVIR', 'Magyar Villamosenergia-ipari Átviteli Rendszerirányító ZRt.', 46)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MDA', 'MDA', 'Ameritech', 47)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MDK', 'MDK', 'Montana-Dakota ', 48)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ME', 'ME', 'Central Maine Power Company', 49)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MEPSO', 'MEPSO', 'MEPSO', 50)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('METC', 'MTC', 'Michigan Electric Transmission Co.', 51)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MISO', 'MSO', 'Midwest ISO', 52)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MPC', 'MPC', 'Minnkota Power Collective', 53)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('MTB', 'MTB', 'Manitoba Hydro', 54)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('NE', 'NE', 'National Grid USA', 55)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('NEISO', 'NEI', 'New England ISO', 56)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('NH', 'NH', 'Public Service Company of New Hampshire', 57)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('NOJA', 'NOJA', 'NOJA Power Switchgear', 58)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('NOS BiH', 'NOS BiH', 'BiH Independent System Operator', 59)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('NYPA', 'NYP', 'New York Power Authority', 60)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('OGE', 'OGE', 'Oklahoma Gas & Electric', 61)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('ONS', 'ONS', 'Operador Nacional do Sistema Elétrico', 62)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('OST', 'OST', 'Operatori I Sistemit te Transmetimit', 63)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('PGE', 'PGE', 'Pacific Gas and Electric', 64)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('PJM', 'PJM', 'PJM Interconnection', 65)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('PPL', 'PPL', 'PPL Electric Utilities', 66)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('PSE', 'PSE', 'Polskie Sieci Elektroenergetyczne', 67)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('REE', 'REE', 'Red Eléctrica de España', 68)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('REN', 'REN', 'Redes Energéticas Nacionais', 69)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('RTE', 'RTE', 'Réseau de Transport d''Électricité', 70)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SCE', 'SCE', 'Southern California Edison', 71)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SDGE', 'SDGE', 'San Diego Gas & Electric', 72)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SEPS', 'SEPS', 'Slovenská elektrizačná prenosová sústava', 73)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SOCO', 'SOC', 'Southern Company', 74)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SONI', 'SONI', 'System Operator for Northern Ireland', 75)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SPP', 'SPP', 'Southwest Power Pool', 76)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SSE', 'SSE', 'Scottish and Southern Energy', 77)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Statnett', 'Statnett', 'Statnett', 78)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SVK', 'SVK', 'Svenska Kraftnät', 79)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Swissgrid', 'Swissgrid', 'Swissgrid', 80)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('SWT', 'SWT', 'Southwest (APS and SRP)', 81)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TEİAŞ', 'TEİAŞ', 'Turkish Electricity Transmission Corporation', 82)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TERNA', 'TERNA', 'Terna', 83)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TNG', 'TNG', 'Tennet TSO', 84)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TE', 'TE', 'Transelectrica', 85)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TTN', 'TTN', 'TenneT', 86)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TUG', 'TUG', 'TU Graz', 87)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('TVA', 'TVA', 'Tennessee Valley Authority', 88)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('UI', 'UI', 'United Illuminating Company', 89)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('Ukrenergo', 'Ukrenergo', 'Ukrenergo', 90)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('UTK', 'UTK', 'University of Tennessee, Knoxville', 91)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('VE', 'VE', 'Vermont Electric Company', 92)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('VUEN', 'VUEN', 'Vorarlberger Übertragungsnetz', 93)
GO

INSERT INTO Company(Acronym, MapAcronym, Name, LoadOrder) VALUES ('WAPA', 'WPA', 'Western Area Power Administration', 94)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('IaonFilterAdapter', 'FilterAdapters', 'Defines IFilterAdapter definitions for a PDC node', 1, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('IaonInputAdapter', 'InputAdapters', 'Defines IInputAdapter definitions for a PDC node', 2, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('IaonActionAdapter', 'ActionAdapters', 'Defines IActionAdapter definitions for a PDC node', 3, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('IaonOutputAdapter', 'OutputAdapters', 'Defines IOutputAdapter definitions for a PDC node', 4, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('ActiveMeasurement', 'ActiveMeasurements', 'Defines active system measurements for a PDC node', 5, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('RuntimeInputStreamDevice', 'InputStreamDevices', 'Defines input stream devices associated with a concentrator', 6, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('RuntimeOutputStreamDevice', 'OutputStreamDevices', 'Defines output stream devices defined for a concentrator', 7, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('RuntimeOutputStreamMeasurement', 'OutputStreamMeasurements', 'Defines the measurements in an output stream', 8, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('OutputStreamDevicePhasor', 'OutputStreamDevicePhasors', 'Defines phasors for output stream devices', 9, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('OutputStreamDeviceAnalog', 'OutputStreamDeviceAnalogs', 'Defines analog values for output stream devices', 10, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('OutputStreamDeviceDigital', 'OutputStreamDeviceDigitals', 'Defines digital values for output stream devices', 11, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('RuntimeStatistic', 'Statistics', 'Defines statistics that are monitored for devices and output streams', 12, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('Subscriber', 'Subscribers', 'Defines subscribers that can request streaming points from a Gateway node', 13, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('SubscriberMeasurement', 'SubscriberMeasurements', 'Defines measurements associated with a Gateway subscriber', 14, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('SubscriberMeasurementGroup', 'SubscriberMeasurementGroups', 'Defines measurement groups associated with a Gateway subscriber', 15, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('MeasurementGroup', 'MeasurementGroups', 'Defines a group of measurements', 16, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('MeasurementGroupMeasurement', 'MeasurementGroupMeasurements', 'Defines the measurements in a measurement group', 17, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('Alarm', 'Alarms', 'Defines alarms that monitor the values of measurements', 18, 1)
GO

INSERT INTO ConfigurationEntity(SourceName, RuntimeName, Description, LoadOrder, Enabled) VALUES('NodeInfo', 'NodeInfo', 'Defines information about the nodes in the database', 19, 1)
GO

INSERT INTO DataOperation(Description, AssemblyName, TypeName, MethodName, Arguments, LoadOrder, Enabled) VALUES('Time Series Startup Operations', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.TimeSeriesStartupOperations', 'PerformTimeSeriesStartupOperations', '', 0, 1)
GO

INSERT INTO DataOperation(Description, AssemblyName, TypeName, MethodName, Arguments, LoadOrder, Enabled) VALUES('Phasor Data Source Validation', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'PhasorDataSourceValidation', '', 1, 1)
GO

INSERT INTO DataOperation(Description, AssemblyName, TypeName, MethodName, Arguments, LoadOrder, Enabled) VALUES('Optimize Local Historian Settings', 'HistorianAdapters.dll', 'HistorianAdapters.LocalOutputAdapter', 'OptimizeLocalHistorianSettings', '', 2, 1)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('Eastern', 'Eastern Interconnection', 0)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('Western', 'Western Interconnection', 1)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('ERCOT', 'Texas Interconnection', 2)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('Quebec', 'Quebec Interconnection', 3)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('Alaskan', 'Alaskan Interconnection', 4)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('Hawaii', 'Islands of Hawaii', 5)
GO

INSERT INTO Interconnection(Acronym, Name, LoadOrder) VALUES('Europe', 'European Interconnection', 6)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('IeeeC37_118V1', 'IEEE C37.118-2005', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 1)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('IeeeC37_118V2', 'IEEE C37.118.2-2011', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 2)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('IeeeC37_118D6', 'IEEE C37.118 Draft 6', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 3)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('Ieee1344', 'IEEE 1344-1995', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 4)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('BpaPdcStream', 'BPA PDCstream', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 5)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('Iec61850_90_5', 'IEC 61850-90-5', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 6)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('FNet', 'UTK FNET', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 7)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('SelFastMessage', 'SEL Fast Message', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 8)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('Macrodyne', 'Macrodyne', 'Frame', 'Phasor', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.PhasorMeasurementMapper', 9)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('STTP', 'Streaming Telemetry Transport Protocol', 'Measurement', 'Gateway', 'sttp.gsf.dll', 'sttp.DataSubscriber', 10)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('GatewayTransport', 'Gateway Exchange Protocol (GEP)', 'Measurement', 'Gateway', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Transport.DataSubscriber', 11)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('Modbus', 'Modbus Poller', 'Measurement', 'Device', 'ModbusAdapters.dll', 'ModbusAdapters.ModbusPoller', 12)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('DNP3', 'DNP3 (Master)', 'Measurement', 'Device', 'Dnp3Adapters.dll', 'DNP3Adapters.DNP3InputAdapter', 13)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('WAV', 'Wave Form Input Adapter', 'Frame', 'Audio', 'WavInputAdapter.dll', 'WavInputAdapter.WavInputAdapter', 14)
GO

INSERT INTO Protocol(Acronym, Name, Type, Category, AssemblyName, TypeName, LoadOrder) VALUES('VirtualInput', 'Virtual Device', 'Frame', 'Virtual', 'TestingAdapters.dll', 'TestingAdapters.VirtualInputAdapter', 15)
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Current Magnitude', 'IPHM', 'PM', 'I', 'CurrentMagnitude', 'Phasor', 'Amps')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Current Phase Angle', 'IPHA', 'PA', 'IH', 'CurrentAngle', 'Phasor', 'Degrees')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Voltage Magnitude', 'VPHM', 'PM', 'V', 'VoltageMagnitude', 'Phasor', 'Volts')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Voltage Phase Angle', 'VPHA', 'PA', 'VH', 'VoltageAngle', 'Phasor', 'Degrees')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Frequency', 'FREQ', 'FQ', 'F', 'Frequency', 'PMU', 'Hz')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Frequency Delta (dF/dt)', 'DFDT', 'DF', 'DF', 'DfDt', 'PMU', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Analog Value', 'ALOG', 'AV', 'AV', 'Analog', 'PMU', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Status Flags', 'FLAG', 'SF', 'S', 'StatusFlags', 'PMU', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Digital Value', 'DIGI', 'DV', 'DV', 'Digital', 'PMU', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Calculated Value', 'CALC', 'CV', 'CV', 'Calculated', 'PMU', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Statistic', 'STAT', 'ST', 'ST', 'Statistic', 'Any', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Alarm', 'ALRM', 'AL', 'AL', 'Alarm', 'Any', '')
GO

INSERT INTO SignalType(Name, Acronym, Suffix, Abbreviation, LongAcronym, Source, EngineeringUnits) VALUES('Quality Flags', 'QUAL', 'QF', 'QF', 'QualityFlags', 'Frame', '')
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 1, 'CPU Usage', 'Percentage of CPU currently used by this process.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_CPUUsage', '', 1, 'System.Double', '{0:N3}', 0, 1)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 2, 'Average CPU Usage', 'Average percentage of CPU used by this process.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageCPUUsage', '', 1, 'System.Double', '{0:N3}', 0, 2)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 3, 'Memory Usage', 'Amount of memory currently used by this process in megabytes.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_MemoryUsage', '', 1, 'System.Double', '{0:N3}', 0, 3)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 4, 'Average Memory Usage', 'Average amount of memory used by this process in megabytes.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageMemoryUsage', '', 1, 'System.Double', '{0:N3}', 0, 4)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 5, 'Thread Count', 'Number of threads currently used by this process.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_ThreadCount', '', 1, 'System.Double', '{0:N3}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 6, 'Average Thread Count', 'Average number of threads used by this process.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageThreadCount', '', 1, 'System.Double', '{0:N3}', 0, 6)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 7, 'Threading Contention Rate', 'Current thread lock contention rate in attempts per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_ThreadingContentionRate', '', 1, 'System.Double', '{0:N3}', 0, 7)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 8, 'Average Threading Contention Rate', 'Average thread lock contention rate in attempts per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageThreadingContentionRate', '', 1, 'System.Double', '{0:N3}', 0, 8)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 9, 'IO Usage', 'Amount of IO currently used by this process in kilobytes per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_IOUsage', '', 1, 'System.Double', '{0:N3}', 0, 9)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 10, 'Average IO Usage', 'Average amount of IO used by this process in kilobytes per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageIOUsage', '', 1, 'System.Double', '{0:N3}', 0, 10)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 11, 'IP Data Send Rate', 'Number of IP datagrams (or bytes on Mono) currently sent by this process per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_IPDataSendRate', '', 1, 'System.Double', '{0:N3}', 0, 11)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 12, 'Average IP Data Send Rate', 'Average number of IP datagrams (or bytes on Mono) sent by this process per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageIPDataSendRate', '', 1, 'System.Double', '{0:N3}', 0, 12)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 13, 'IP Data Receive Rate', 'Number of IP datagrams (or bytes on Mono) currently received by this process per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_IPDataReceiveRate', '', 1, 'System.Double', '{0:N3}', 0, 13)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 14, 'Average IP Data Receive Rate', 'Average number of IP datagrams (or bytes on Mono) received by this process per second.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_AverageIPDataReceiveRate', '', 1, 'System.Double', '{0:N3}', 0, 14)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('System', 15, 'Up Time', 'Total number of seconds system has been running.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.PerformanceStatistics', 'GetSystemStatistic_UpTime', '', 1, 'System.Double', '{0:N3} s', 0, 15)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 1, 'Data Quality Errors', 'Number of data quality errors reported by device during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_DataQualityErrors', '', 1, 'System.Int32', '{0:N0}', 0, 1)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 2, 'Time Quality Errors', 'Number of time quality errors reported by device during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_TimeQualityErrors', '', 1, 'System.Int32', '{0:N0}', 0, 2)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 3, 'Device Errors', 'Number of device errors reported by device during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_DeviceErrors', '', 1, 'System.Int32', '{0:N0}', 0, 3)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 4, 'Measurements Received', 'Number of measurements received from device during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_MeasurementsReceived', '', 1, 'System.Int32', '{0:N0}', 0, 4)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 5, 'Measurements Expected', 'Expected number of measurements received from device during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_MeasurementsExpected', '', 1, 'System.Int32', '{0:N0}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 6, 'Measurements With Error', 'Number of measurements received while device was reporting errors during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_MeasurementsWithError', '', 1, 'System.Int32', '{0:N0}', 0, 6)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Device', 7, 'Measurements Defined', 'Number of defined measurements (per frame) from device during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.DeviceStatistics', 'GetDeviceStatistic_MeasurementsDefined', '', 1, 'System.Int32', '{0:N0}', 0, 7)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 1, 'Total Frames', 'Total number of frames received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_TotalFrames', '', 1, 'System.Int32', '{0:N0}', 0, 2)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 2, 'Last Report Time', 'Timestamp of last received data frame from input stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_LastReportTime', '', 1, 'System.DateTime', '{0:mm'':''ss''.''fff}', 0, 1)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 3, 'Missing Frames', 'Number of frames that were not received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_MissingFrames', '', 1, 'System.Int32', '{0:N0}', 0, 3)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 4, 'CRC Errors', 'Number of CRC errors reported from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_CRCErrors', '', 1, 'System.Int32', '{0:N0}', 0, 16)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 5, 'Out of Order Frames', 'Number of out-of-order frames received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_OutOfOrderFrames', '', 1, 'System.Int32', '{0:N0}', 0, 17)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 6, 'Minimum Latency', 'Minimum latency from input stream, in milliseconds, during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_MinimumLatency', '', 1, 'System.Double', '{0:N3} ms', 0, 10)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 7, 'Maximum Latency', 'Maximum latency from input stream, in milliseconds, during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_MaximumLatency', '', 1, 'System.Double', '{0:N3} ms', 0, 11)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 8, 'Input Stream Connected', 'Boolean value representing if input stream was continually connected during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_Connected', '', 1, 'System.Boolean', '{0}', 1, 18)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 9, 'Received Configuration', 'Boolean value representing if input stream has received (or has cached) a configuration frame during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_ReceivedConfiguration', '', 1, 'System.Boolean', '{0}', 0, 8)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 10, 'Configuration Changes', 'Number of configuration changes reported by input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_ConfigurationChanges', '', 1, 'System.Int32', '{0:N0}', 0, 9)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 11, 'Total Data Frames', 'Number of data frames received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_TotalDataFrames', '', 1, 'System.Int32', '{0:N0}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 12, 'Total Configuration Frames', 'Number of configuration frames received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_TotalConfigurationFrames', '', 1, 'System.Int32', '{0:N0}', 0, 6)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 13, 'Total Header Frames', 'Number of header frames received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_TotalHeaderFrames', '', 1, 'System.Int32', '{0:N0}', 0, 7)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 14, 'Average Latency', 'Average latency, in milliseconds, for data received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_AverageLatency', '', 1, 'System.Double', '{0:N3} ms', 0, 12)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 15, 'Defined Frame Rate', 'Frame rate as defined by input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_DefinedFrameRate', '', 1, 'System.Int32', '{0:N0} frames / second', 0, 13)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 16, 'Actual Frame Rate', 'Latest actual mean frame rate for data received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_ActualFrameRate', '', 1, 'System.Double', '{0:N3} frames / second', 0, 14)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 17, 'Actual Data Rate', 'Latest actual mean Mbps data rate for data received from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_ActualDataRate', '', 1, 'System.Double', '{0:N3} Mbps', 0, 15)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 18, 'Missing Data', 'Number of data units that were not received at least once from input stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_MissingData', '', 1, 'System.Int32', '{0:N0}', 0, 4)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 19, 'Total Bytes Received', 'Number of bytes received from the input source during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_TotalBytesReceived', '', 1, 'System.Int32', '{0:N0}', 0, 19)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 20, 'Lifetime Measurements', 'Number of processed measurements reported by the input stream during the lifetime of the input stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_LifetimeMeasurements', '', 1, 'System.Int64', '{0:N0}', 0, 20)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 21, 'Lifetime Bytes Received', 'Number of bytes received from the input source during the lifetime of the input stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_LifetimeBytesReceived', '', 1, 'System.Int64', '{0:N0}', 0, 21)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 22, 'Minimum Measurements Per Second', 'The minimum number of measurements received per second during the last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_MinimumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 22)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 23, 'Maximum Measurements Per Second', 'The maximum number of measurements received per second during the last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_MaximumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 23)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 24, 'Average Measurements Per Second', 'The average number of measurements received per second during the last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_AverageMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 24)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 25, 'Lifetime Minimum Latency', 'Minimum latency from input stream, in milliseconds, during the lifetime of the input stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_LifetimeMinimumLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 25)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 26, 'Lifetime Maximum Latency', 'Maximum latency from input stream, in milliseconds, during the lifetime of the input stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_LifetimeMaximumLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 26)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 27, 'Lifetime Average Latency', 'Average latency, in milliseconds, for data received from input stream during the lifetime of the input stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_LifetimeAverageLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 27)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('InputStream', 28, 'Up Time', 'Total number of seconds input stream has been running.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetInputStreamStatistic_UpTime', '', 1, 'System.Double', '{0:N3} s', 0, 28)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 1, 'Discarded Measurements', 'Number of discarded measurements reported by output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_DiscardedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 4)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 2, 'Received Measurements', 'Number of received measurements reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_ReceivedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 2)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 3, 'Expected Measurements', 'Number of expected measurements reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_ExpectedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 1)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 4, 'Processed Measurements', 'Number of processed measurements reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_ProcessedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 3)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 5, 'Measurements Sorted by Arrival', 'Number of measurements sorted by arrival reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_MeasurementsSortedByArrival', '', 1, 'System.Int32', '{0:N0}', 0, 7)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 6, 'Published Measurements', 'Number of published measurements reported by output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_PublishedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 7, 'Downsampled Measurements', 'Number of downsampled measurements reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_DownsampledMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 6)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 8, 'Missed Sorts by Timeout', 'Number of missed sorts by timeout reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_MissedSortsByTimeout', '', 1, 'System.Int32', '{0:N0}', 0, 8)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 9, 'Frames Ahead of Schedule', 'Number of frames ahead of schedule reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_FramesAheadOfSchedule', '', 1, 'System.Int32', '{0:N0}', 0, 9)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 10, 'Published Frames', 'Number of published frames reported by the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_PublishedFrames', '', 1, 'System.Int32', '{0:N0}', 0, 10)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 11, 'Output Stream Connected', 'Boolean value representing if the output stream was continually connected during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_Connected', '', 1, 'System.Boolean', '{0}', 1, 11)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 12, 'Minimum Latency', 'Minimum latency from output stream, in milliseconds, during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_MinimumLatency', '', 1, 'System.Double', '{0:N3} ms', 0, 12)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 13, 'Maximum Latency', 'Maximum latency from output stream, in milliseconds, during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_MaximumLatency', '', 1, 'System.Double', '{0:N3} ms', 0, 13)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 14, 'Average Latency', 'Average latency, in milliseconds, for data published from output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_AverageLatency', '', 1, 'System.Double', '{0:N3} ms', 0, 14)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 15, 'Connected Clients', 'Number of clients connected to the command channel of the output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_ConnectedClientCount', '', 1, 'System.Int32', '{0:N0}', 0, 15)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 16, 'Total Bytes Sent', 'Number of bytes sent from output stream during last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_TotalBytesSent', '', 1, 'System.Int32', '{0:N0}', 0, 16)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 17, 'Lifetime Measurements', 'Number of processed measurements reported by the output stream during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeMeasurements', '', 1, 'System.Int64', '{0:N0}', 0, 17)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 18, 'Lifetime Bytes Sent', 'Number of bytes sent from the output source during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeBytesSent', '', 1, 'System.Int64', '{0:N0}', 0, 18)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 19, 'Minimum Measurements Per Second', 'The minimum number of measurements sent per second during the last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_MinimumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 19)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 20, 'Maximum Measurements Per Second', 'The maximum number of measurements sent per second during the last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_MaximumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 20)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 21, 'Average Measurements Per Second', 'The average number of measurements sent per second during the last reporting interval.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_AverageMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 21)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 22, 'Lifetime Minimum Latency', 'Minimum latency from output stream, in milliseconds, during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeMinimumLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 22)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 23, 'Lifetime Maximum Latency', 'Maximum latency from output stream, in milliseconds, during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeMaximumLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 23)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 24, 'Lifetime Average Latency', 'Average latency from output stream, in milliseconds, during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeAverageLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 24)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 25, 'Lifetime Discarded Measurements', 'Number of discarded measurements reported by output stream during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeDiscardedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 25)
GO

INSERT INTO Statistic(Source, SignalIndex, Name, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 26, 'Lifetime Downsampled Measurements', 'Number of downsampled measurements reported by the output stream during the lifetime of the output stream.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_LifetimeDownsampledMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 26)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('OutputStream', 27, 'Up Time', 'Total number of seconds output stream has been running.', 'PhasorProtocolAdapters.dll', 'PhasorProtocolAdapters.CommonPhasorServices', 'GetOutputStreamStatistic_UpTime', '', 1, 'System.Double', '{0:N3} s', 0, 27)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 1, 'Subscriber Connected', 'Boolean value representing if the subscriber was continually connected during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_Connected', '', 1, 'System.Boolean', '{0}', 1, 1)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 2, 'Subscriber Authenticated', 'Boolean value representing if the subscriber was authenticated to the publisher during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_Authenticated', '', 1, 'System.Boolean', '{0}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 3, 'Processed Measurements', 'Number of processed measurements reported by the subscriber during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_ProcessedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 3)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 4, 'Total Bytes Received', 'Number of bytes received from subscriber during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_TotalBytesReceived', '', 1, 'System.Int32', '{0:N0}', 0, 4)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 5, 'Authorized Signal Count', 'Number of signals authorized to the subscriber by the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_AuthorizedCount', '', 1, 'System.Int32', '{0:N0}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 6, 'Unauthorized Signal Count', 'Number of signals denied to the subscriber by the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_UnauthorizedCount', '', 1, 'System.Int32', '{0:N0}', 0, 6)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 7, 'Lifetime Measurements', 'Number of processed measurements reported by the subscriber during the lifetime of the subscriber.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_LifetimeMeasurements', '', 1, 'System.Int64', '{0:N0}', 0, 7)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 8, 'Lifetime Bytes Received', 'Number of bytes received from subscriber during the lifetime of the subscriber.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_LifetimeBytesReceived', '', 1, 'System.Int64', '{0:N0}', 0, 8)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 9, 'Minimum Measurements Per Second', 'The minimum number of measurements received per second during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_MinimumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 9)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 10, 'Maximum Measurements Per Second', 'The maximum number of measurements received per second during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_MaximumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 10)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 11, 'Average Measurements Per Second', 'The average number of measurements received per second during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_AverageMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 11)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 12, 'Lifetime Minimum Latency', 'Minimum latency from output stream, in milliseconds, during the lifetime of the subscriber.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_LifetimeMinimumLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 12)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 13, 'Lifetime Maximum Latency', 'Maximum latency from output stream, in milliseconds, during the lifetime of the subscriber.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_LifetimeMaximumLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 13)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 14, 'Lifetime Average Latency', 'Average latency from output stream, in milliseconds, during the lifetime of the subscriber.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_LifetimeAverageLatency', '', 1, 'System.Int32', '{0:N0} ms', 0, 14)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Subscriber', 15, 'Up Time', 'Total number of seconds subscriber has been running.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetSubscriberStatistic_UpTime', '', 1, 'System.Double', '{0:N3} s', 0, 15)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 1, 'Publisher Connected', 'Boolean value representing if the publisher was continually connected during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_Connected', '', 1, 'System.Boolean', '{0}', 1, 1)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 2, 'Connected Clients', 'Number of clients connected to the command channel of the publisher during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_ConnectedClientCount', '', 1, 'System.Int32', '{0:N0}', 0, 2)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 3, 'Processed Measurements', 'Number of processed measurements reported by the publisher during last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_ProcessedMeasurements', '', 1, 'System.Int32', '{0:N0}', 0, 3)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 4, 'Total Bytes Sent', 'Number of bytes sent by the publisher during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_TotalBytesSent', '', 1, 'System.Int32', '{0:N0}', 0, 4)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 5, 'Lifetime Measurements', 'Number of processed measurements reported by the publisher during the lifetime of the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_LifetimeMeasurements', '', 1, 'System.Int64', '{0:N0}', 0, 5)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 6, 'Lifetime Bytes Sent', 'Number of bytes sent by the publisher during the lifetime of the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_LifetimeBytesSent', '', 1, 'System.Int64', '{0:N0}', 0, 6)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 7, 'Minimum Measurements Per Second', 'The minimum number of measurements sent per second during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_MinimumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 7)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 8, 'Maximum Measurements Per Second', 'The maximum number of measurements sent per second during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_MaximumMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 8)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 9, 'Average Measurements Per Second', 'The average number of measurements sent per second during the last reporting interval.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_AverageMeasurementsPerSecond', '', 1, 'System.Int32', '{0:N0}', 0, 9)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 10, 'Lifetime Minimum Latency', 'Minimum latency from output stream, in milliseconds, during the lifetime of the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_LifetimeMinimumLatency', '', 1, 'System.Int64', '{0:N0} ms', 0, 10)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 11, 'Lifetime Maximum Latency', 'Maximum latency from output stream, in milliseconds, during the lifetime of the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_LifetimeMaximumLatency', '', 1, 'System.Int64', '{0:N0} ms', 0, 11)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 12, 'Lifetime Average Latency', 'Average latency from output stream, in milliseconds, during the lifetime of the publisher.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_LifetimeAverageLatency', '', 1, 'System.Int64', '{0:N0} ms', 0, 12)
GO

INSERT INTO Statistic(Source, SignalIndex, NAME, Description, AssemblyName, TypeName, MethodName, Arguments, Enabled, DataType, DisplayFormat, IsConnectedState, LoadOrder) VALUES('Publisher', 13, 'Up Time', 'Total number of seconds publisher has been running.', 'GSF.TimeSeries.dll', 'GSF.TimeSeries.Statistics.GatewayStatistics', 'GetPublisherStatistic_UpTime', '', 1, 'System.Double', '{0:N3} s', 0, 13)
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('ABB', 'ABB', '', '', 'http://www.abb.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('ARB', 'Arbiter', '', '', 'http://www.arbiter.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('ATK', 'Ametek', '', '', 'http://www.ametek.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('BPA', 'Bonneville Power Administration', '', '', 'http://www.bpa.gov/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('GE', 'General Electric', '', '', 'http://www.ge.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('HWY', 'Hathaway', '', '', 'http://www.qualitrolcorp.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('MAC', 'Macrodyne', '', '', 'http://www.macrodyneusa.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('MTA', 'Mehtatech', '', '', 'http://www.mehtatech.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('NPT', 'NxtPhase', '', '', 'http://www.nxtphase.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('OTR', 'Other / Unspecified', '', '', '')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('SEL', 'Schweitzer', '', '', 'http://www.selinc.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('GPA', 'Grid Protection Alliance', '', '', 'http://www.gridprotectionalliance.org/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('UTK', 'University of Tennessee, Knoxville', '', '', 'http://www.utk.edu/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('SIE', 'Siemens', '', '', 'http://www.siemens.com/')
GO

INSERT INTO Vendor(Acronym, Name, PhoneNumber, ContactEmail, URL) VALUES('EPG', 'Electric Power Group', '', '', 'http://www.electricpowergroup.com/')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(2, 'Arbiter-1133A', 'Arbiter 1133A Power Sentinel', 'http://www.arbiter.com/catalog/power/1133a/1133a.php')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(1, 'ABB-521', 'ABB RES521', 'http://library.abb.com/GLOBAL/SCOT/SCOT296.nsf/VerityDisplay/79B16E5CF206C79CC125712D0074AC6F/$File/1MRK511113-HEN_D_en_Phasor_Measurement_Terminal_RES_521.pdf')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(8, 'Mehtatech', 'Metha Tech Transcan 2000 IED', 'http://www.mehtatech.com/pdf/IEDbrochMay02b.pdf')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(7, 'Macrodyne', 'Macrodyne 1690', 'http://www.macrodyneusa.com/model_1690.htm')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(11, 'SEL-421', 'SEL-421 Relay', 'http://www.selinc.com/sel-421.htm')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(4, 'BPA PDC', 'Bonneville Power Administration', 'http://www.bpa.gov/')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(6, 'Hathaway IDM', 'Qualitrol Hathaway IDM Fault Recorder', 'http://www.qualitrolcorp.com/docs/home/IDM_Brochure.pdf')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(3, 'Ametek', 'Ametek TR-2000 Multi-Function Recorder', 'http://www.ametekpower.com/products/sku.cfm?SKU_Id=12328')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(9, 'NxtPhase', 'NxtPhase Telsa 2000 Fault Recorder', 'http://www.nxtphase.com/sub-products-relays-tesla-model-2000P.htm')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(10, 'Other', 'Other Device', '')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(11, 'SEL-5077', 'SEL-5077 SynchroWAVe Server Software', 'http://www.selinc.com/synchrowave.htm')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(11, 'SEL-451', 'SEL-451 Relay', 'http://www.selinc.com/sel-451.htm')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(11, 'SEL-3306', 'SEL-3306 Synchrophasor Processor', 'http://synchrophasor.selinc.com/')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(5, 'GE N60', 'GE N60 Synchrophasor Measurement System', 'http://www.geindustrial.com/cwc/products?pnlid=6&famid=31&catid=234&id=n60&lang=en_US')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(12, 'openPDC', 'Open Source Phasor Data Concentrator', 'http://www.openpdc.com/')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(13, 'FNET', 'UTK FNET Device', '')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(11, 'SEL-3373', 'SEL-3373 Synchrophasor Data Concentrator', 'http://www.selinc.com/SEL-3373/')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(14, 'SIMEAS R-PMU', '7KE6100 Digital Fault Recorder & PMU', 'http://www.energy.siemens.com/mx/en/automation/power-transmission-distribution/power-quality/simeas-r-pmu.htm')
GO

INSERT INTO VendorDevice(VendorID, Name, Description, URL) VALUES(15, 'ePDC', 'ePDC & eSPDC', 'http://www.electricpowergroup.com/solutions/epdc/index.html')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Good', 'green')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Alarm', 'red')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Not Available', 'orange')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Bad Data', 'blue')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Bad Time', 'purple')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Out of Service', 'grey')
GO

INSERT INTO AlarmState (State, Color) VALUES ('Acknowledged', 'rosybrown')
GO 

USE openPDC
GO
